<?php
// mencegah direct access file PHP agar file PHP tidak bisa diakses secara langsung dari browser dan hanya dapat dijalankan ketika di include oleh file lain
// jika file diakses secara langsung
if (basename($_SERVER['PHP_SELF']) === basename(__FILE__)) {
  // alihkan ke halaman error 404
  header('location: 404.html');
}
// jika file di include oleh file lain, tampilkan isi file
else {
  // mengecek data GET "id_pekerjaan"
  if (isset($_GET['id'])) {
    // ambil data GET dari tombol ubah
    $id_pekerjaan = $_GET['id'];

    // sql statement untuk menampilkan data dari tabel "tbl_pekerjaan" berdasarkan "id_pekerjaan"
    $query = mysqli_query($mysqli, "SELECT tbl_pekerjaan.id_pekerjaan, tbl_pekerjaan.nama_pekerjaan, tbl_kategori.id_kategori, tbl_kategori.nama_kategori FROM tbl_kategori JOIN tbl_pekerjaan ON tbl_pekerjaan.kategori_id = tbl_kategori.id_kategori WHERE id_pekerjaan='$id_pekerjaan'")
                                              or die('Ada kesalahan pada query tampil data : ' . mysqli_error($mysqli));
    // ambil data hasil query
    $data = mysqli_fetch_assoc($query);
  }
?>
  <div class="container-fluid">
    <!-- judul halaman -->
    <h1 class="h4 mb-4 text-gray-800"><i class="fas fa-clone fa-fw mr-2"></i>Pekerjaan</h1>

    <div class="card shadow mb-4">
      <div class="card-header py-3">
        <!-- judul form -->
        <h6 class="m-0 font-weight-bold">Ubah Data Pekerjaan</h6>
      </div>
      <div class="card-body">
        <!-- form ubah data -->
        <form action="modules/pekerjaan/proses_ubah.php" method="post" class="needs-validation" novalidate>
          <input type="hidden" name="id_pekerjaan" value="<?php echo $data['id_pekerjaan']; ?>">

          <div class="form-group">
            <label>Nama pekerjaan <span class="text-danger">*</span></label>
            <input type="text" name="nama_pekerjaan" class="form-control col-lg-5" autocomplete="off" value="<?php echo $data['nama_pekerjaan']; ?>" required>
            <div class="invalid-feedback">Nama pekerjaan tidak boleh kosong.</div>
          </div>

          <div class="form-group">
            <label>Kategori <span class="text-danger">*</span></label>
            <select name="kategori" class="form-control col-lg-5" autocomplete="off" required>
              <option value="<?php echo $data['kategori_id']; ?>"><?php echo $data['nama_kategori']; ?></option>
              <!-- <option disabled value="">-- Pilih --</option> -->
              <?php
                // sql statement untuk menampilkan data dari tabel "tbl_kategori"
                $query2 = mysqli_query($mysqli, "SELECT * FROM tbl_kategori");
                // ambil data hasil query
                while ($data2 = mysqli_fetch_assoc($query2)) { ?>
                <option value="<?= $data2['id_kategori']; ?>"><?= $data2['nama_kategori']; ?></option>
              <?php } ?>
            </select>
            <div class="invalid-feedback">Tipe tidak boleh kosong.</div>
          </div>

          <hr class="mt-5">

          <div class="form-group pt-3">
            <!-- tombol simpan data -->
            <input type="submit" name="simpan" value="Simpan" class="btn btn-success pl-4 pr-4 mr-2">
            <!-- tombol kembali ke halaman tampil data -->
            <a href="?module=pekerjaan" class="btn btn-secondary pl-4 pr-4">Batal</a>
          </div>
        </form>
      </div>
    </div>
  </div>
<?php } ?>